## Product sense table

| Theme / Prompt                          | Product Mission                                                  | MECE Demand-Side User Segments                                                             | User Journey                                                       | 5x High-Frequency Pain Points                                                                                           | 3x Solution Techniques                                                                         | North Star Metric                                   |
| --------------------------------------- | ---------------------------------------------------------------- | ------------------------------------------------------------------------------------------ | ------------------------------------------------------------------ | ----------------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------------------------------------------------- |
| **Travel**                              | Help people discover, plan, and share meaningful travel          | Solo travelers, Group/friends, Family w/ kids, Business travelers                          | Discover → Plan → Book → Experience → Share                        | Hard to coordinate group, Can’t compare options, Budget uncertainty, Miss hidden gems, Forget to share memories         | AI Itinerary Assistant, Group Collab on WhatsApp/FB, Marketplace integration (Airbnb, Expedia) | # of shared itineraries/trips completed             |
| **Healthcare (reactive)**               | Help people access the right care quickly & confidently          | Patients, Caregivers, Doctors/clinics, Insurers                                            | Symptom check → Find provider → Book → Visit → Follow-up           | Don’t know which doctor to see, Appointment delays, Insurance confusion, Trust in provider, Lack of reminders           | AI triage chatbot, Provider discovery via FB/IG, Seamless booking & reminders                  | # of patients completing booked visits via platform |
| **Fitness & Mental Health (proactive)** | Build daily healthy habits with community support                | Beginners, Fitness enthusiasts, Mental health seekers, Trainers, Wellness content creators | Discover → Plan → Track → Engage → Share progress                  | Hard to stay motivated, Don’t know right plan, Inconsistent tracking, Stigma in sharing, Hard to measure progress       | Habit streaks & gamification, Group challenges on WhatsApp/FB, AI coach nudges                 | Weekly Active Users w/ ≥3 tracked sessions          |
| **Find Handyperson**                    | Make home fixes fast, reliable, and trustworthy                  | Homeowners, Renters, Property managers                                                     | Need arises → Search → Compare → Book → Job done → Review          | Trust in quality, Pricing not transparent, Availability issues, Coordination hassle, No recourse if bad work            | Ratings/reviews system, Escrow/payments protection, Matching via location                      | % of jobs booked & completed successfully           |
| **Enjoy Art**                           | Make art discovery and appreciation accessible                   | Art lovers, Students, Casual browsers, Artists, Museums                                    | Discover → Experience → Engage → Share → Revisit                   | Hard to find relevant art, High barrier (time/money), Not interactive, Lack of community, No discovery of local events  | AR/VR immersive art, Community art sharing via IG, Curated events feed                         | Time spent engaging with art content                |
| **Find Jobs**                           | Connect people to jobs that fit their skills & goals             | Students, Early-career, Experienced pros, Freelancers, Employers                           | Profile setup → Discover → Apply → Interview → Offer               | Too many irrelevant jobs, Hard to stand out, Lack of trusted referrals, Slow employer response, Low transparency        | Skill-based job matching, Social graph referrals, AI resume coach                              | # of users hired via platform per quarter           |
| **Find Pets (new pets)**                | Help people find trusted pets and breeders                       | Families, Single adults, Seniors, Breeders/shelters                                        | Browse → Evaluate → Reserve → Adopt → Care                         | Fake breeders, Safety concerns, No fit with lifestyle, Logistics of adoption, Post-adoption support gaps                | Verified breeder network, Lifestyle-matching quiz, Adoption support communities                | # of successful adoptions completed                 |
| **Book Movie Tickets**                  | Make movie-going social, fun, and frictionless                   | Individuals, Groups of friends, Families, Movie clubs                                      | Discover → Select show → Book seats → Attend → Review/share        | Hard to coordinate times, Long booking flows, Seat availability, No loyalty benefits, Forget to share plan              | Group booking integration via WhatsApp, One-click payment, Loyalty/points gamification         | % of tickets booked through Meta platform           |
| **Video Conferencing**                  | Make virtual conversations natural, social, and immersive        | Friends/family, Students, Professionals, Creators                                          | Schedule → Join → Interact → Share → Rejoin                        | Tech setup issues, Fatigue, Lack of engagement, Privacy concerns, Awkward transitions                                   | Avatar/AR presence, Interactive polls & games, Cross-app integration (IG/WA)                   | Weekly active meetings per user                     |
| **Volunteering**                        | Mobilize people to give time/resources to causes they care about | Local volunteers, Casual volunteers, CSR groups, NGOs, Gov agencies                        | Discover → Join → Participate → Share → Repeat                     | Hard to find relevant opps, Trust in orgs, Logistics unclear, Time mismatch, Low motivation post-event                  | Cause-matching AI, Group volunteering via WA/FB, Reputation/impact scores                      | # of volunteer hours logged on platform             |
| **Fundraising**                         | Enable authentic, frictionless fundraising at scale              | Individuals w/ personal causes, Nonprofits, CSR teams, Donors                              | Create campaign → Publish → Donate → Track → Share                 | Hard to write compelling ask, Trust/authenticity, Payment friction, Lack of updates, Donor fatigue                      | Storytelling templates, Trusted badges/verifications, Easy recurring donations                 | \$ raised per active fundraiser                     |
| **Homework Help**                       | Provide safe, effective homework assistance for students         | Middle-schoolers, High-schoolers, College students, Parents, Tutors                        | Ask question → Discover tutor/AI → Learn → Practice → Review/share | Don’t know if answer is correct, Tutors not available, Delays in response, Want concept not just answer, Trust & safety | AI tutor + human backup, Group study mode, Quizzes to test mastery                             | % of students w/ improved quiz score after sessions |
| **Gardening**                           | Help people grow plants successfully with community & guidance   | Hobbyists, Serious gardeners, Urban apartment dwellers, Community gardens                  | Plan → Buy supplies → Grow → Track → Share                         | Don’t know what grows locally, Pest/disease issues, Forget watering, No peer community, Cost of supplies                | AR plant ID & tips, Reminders via WA/FB, Local gardener community                              | # of plants tracked successfully over time          |
| **Home Buying**                         | Make home buying transparent, social, and stress-free            | First-time buyers, Repeat buyers, Investors, Agents, Lenders                               | Discover → Shortlist → Visit → Finance → Close                     | Overwhelming info, Hidden costs, Hard to compare, Lack of trusted advice, Stressful paperwork                           | VR/AR home tours, Mortgage calculators, Social graph referrals to agents                       | % of buyers completing home purchase journey        |
| **Farm People (agriculture)**           | Empower farmers with knowledge, tools, and connections           | Small farmers, Large farmers, Co-ops, Suppliers, Govt agencies                             | Plan crop → Plant → Grow → Harvest → Sell                          | No trusted pricing info, Lack of weather insights, Poor market access, Limited financing, No peer sharing               | Weather alerts via WA, Market price transparency, Farmer community groups                      | % increase in farmers’ net income via platform      |

### Generalized 2-Sided Marketplace Framework

| #   | Domain                      | Top apps                          | Type | Demand Side Journey                            | Supply Side Journey                               | North Star Metric (NSM)           | Supporting Success Metrics                                      | Guardrail Metrics                                        | Monetization Levers                         | Platform Quality Metrics                               | Satisfaction Signals                 | Common Failure Modes / Anti-Patterns                                 |
| --- | --------------------------- | --------------------------------- | ---- | ---------------------------------------------- | ------------------------------------------------- | --------------------------------- | --------------------------------------------------------------- | -------------------------------------------------------- | ------------------------------------------- | ------------------------------------------------------ | ------------------------------------ | -------------------------------------------------------------------- |
| 1   | Social media/live streaming | Insta/FB, YouTube,                | E    | Discover > View > Interact > Follow/Return     | Signup > Stream/Upload > Grow audience > Monetize | Daily Active Engaged Users (DAEU) | Session duration, Shares, Comments, Retention, Follower growth  | Abuse rate, Content violation rate, Drop in engagement   | Ads, Creator tipping, Paid promotions       | Video load time, Crash rate, Moderation coverage       | NPS, Creator earnings, Abuse reports | Spammy content, Creator burnout, Algorithmic bias, Safety incidents  |
| 2   | eCommerce marketplace       | FB Marketplace, eBay, Walmart     | T    | Search > Evaluate > Buy > Repeat               | Onboard > List > Sell > Fulfill > Support         | Weekly Transacting Buyers         | Conversion rate, AOV, Fulfillment rate, Return rate             | Return abuse rate, Fake reviews %, Cart abandonment rate | Commission, Ads, Fulfillment services       | Page load, Uptime, Fulfillment errors                  | Buyer reviews, Seller response time  | Counterfeit goods, Fake reviews, Abandoned carts, Price undercutting |
| 3   | Podcast, music              | Spotify, Apple Music              | E    | Browse > Listen > Like/Follow > Subscribe      | Upload > Get discovered > Grow > Monetize         | Monthly Active Listeners          | Listening time, Retention, Playlist saves, Creator growth       | Skip rate, Drop-off early %, Unsub rate                  | Ads, Premium subscriptions, Creator payouts | Stream reliability, Download success rate              | Rating, Subscriber growth            | Repetitive content, Discovery fatigue, Unfair payouts                |
| 4   | TV shows, movies streaming  | Netflix, Max, Disney+, Apple TV+, | T    | Browse > Watch > Continue > Upgrade/Subscribe  | Acquire/show content > Licensing                  | Total Watch Hours per Subscriber  | Completion rate, Churn, Viewership by content type              | Churn %, Rebuffering %, App crash rate                   | Subscription, Licensing deals               | Buffering, HD availability, Personalization quality    | NPS, Churn rate, Ratings             | Low engagement on new shows, Content over-saturation, Churn spikes   |
| 5   | Taxi rides                  | Uber, Lyft                        | T    | Search > Book > Ride > Rate > Repeat           | Signup > Accept rides > Drive > Earn              | Weekly Rides Completed            | Wait time, Ride success %, Driver availability, Earnings/Ride   | Cancellation rate, Low rating %, ETA deviation %         | Commission per ride                         | App uptime, Driver app reliability                     | Ride rating, Tip %, Repeat usage     | Long wait times, Driver cancellations, Poor matching                 |
| 6   | Delivery apps               | Uber, DoorDash                    | T    | Search > Order > Receive > Reorder             | Signup > Accept delivery > Deliver > Earn         | Orders Delivered per Week         | Fulfillment time, CSAT, Avg order value, Delivery accuracy      | Late delivery %, Support ticket volume, Rejection %      | Commission, Delivery fee, Premium listings  | Delivery success rate, Route accuracy                  | Support tickets, Order rating        | Missed delivery windows, Stockout, Food quality issues               |
| 7   | Maps                        | Google Maps, Apple Maps           | E    | Search > Navigate > Save > Review              | Claim business > Update info > Promote            | Weekly Engaged Users              | Searches/user, Navigation starts, Review submissions            | Data freshness lag, Duplicate listing rate               | Promoted listings, Local ads                | Location accuracy, Data freshness                      | Review quality, Feature usage        | Misinformation, Fake listings, Poor routing                          |
| 8   | Events apps                 | FB Events, GCal, Eventbrite       | T    | Discover > RSVP > Attend > Share               | Create event > Promote > Host                     | Successful Event Attendance       | RSVPs, Check-in rate, Repeat organizers                         | No-show %, Refund volume, App crash %                    | Ticketing fees, Ads, Subscription tools     | App uptime, Ticket scanning accuracy                   | Event ratings, Refund requests       | Low attendance, No-show spikes, Discovery fatigue                    |
| 9   | Gaming (AR/VR)              | Quest, HoloLens                   | E    | Discover > Play > Engage > Return              | Build > Publish > Monetize                        | Weekly Active Users               | Session time, Engagement %, Creator retention                   | Abuse rate, Hardware crash %, Toxicity reports           | In-app purchases, Platform cut, Ads         | Latency, FPS, Bug/crash rate                           | Game ratings, Creator earnings       | Toxicity in games, Abuse, Poor dev tools, Hardware fragmentation     |
| 10  | Grocery retail              | Walmart, Costco, Whole Foods      | T    | Browse > Order > Receive > Reorder             | Onboard > Upload inventory > Fulfill              | Orders per Weekly Active Buyer    | Order accuracy, Delivery time, Inventory freshness              | Return/refund rate, Out-of-stock %, CSAT drop            | Commission, Fulfillment, Ads                | Order tracking, Stock sync accuracy                    | Freshness score, Complaints          | Perishables loss, Stock mismatches, Refund abuse                     |
| 11  | Hotels                      | Airbnb, Mariott                   | T    | Search > Book > Stay > Review                  | List property > Manage bookings > Host            | Room-Nights Booked per Week       | Avg booking value, Occupancy %, Cancellation rate               | Overbooking rate, Low review score %, Late response %    | Booking commission, Ads, Premium tools      | Booking speed, Calendar sync, Confirmation reliability | Review ratings, Support tickets      | Double bookings, No-shows, Poor quality control                      |
| 12  | Flights                     | AA, United, Delta                 | T    | Search > Book > Fly > Feedback                 | Upload schedule > Operate flight                  | Flights Booked per Week           | Seat fill %, Delay rate, Check-in success                       | Delay %, Refund rate, Complaint volume                   | Booking fees, Ancillary purchases           | Real-time update accuracy, Seat availability           | Delay complaints, App uninstall rate | Delay spikes, Seat mapping errors, Refund complexity                 |
| 13  | Facebook Marketplace        | eBay, Craigslist                  | T    | Search > Contact > Negotiate > Transact > Rate | Post item > Respond > Meet > Transact             | Weekly Active Transactions        | Messages initiated, Items sold %, Buyer repeat %, Listing views | Fraud reports, Meet-up failure %, Rating drop            | Ads, Promoted listings                      | Message delivery success, Profile verification rate    | User rating, Message response time   | Scams, No-shows, Trust breakdowns, Low-quality listings              |

### Highlighted Generic Metrics
- **North Star**:
  - **Engagement-driven (E)**: DAUs with meaningful sessions (time spent, shares, etc.)
  - **Transaction-driven (T)**: Weekly/monthly transactions per active user
- **Platform Quality**:
  - Latency, Throughput, Response time
  - Error rate / Crash rate
  - Data accuracy
- **Satisfaction**:
  - NPS
  - Ratings & Reviews
  - Support volume / Churn


### Failure Mode Themes (Cross-cutting)
- **Liquidity gaps**: Not enough supply or demand at the right time
- **Cold start**: New users don’t find value fast enough (especially creators/suppliers)
- **Mismatched incentives**: Leads to spammy supply or demand churn
- **Poor discovery**: Quality content or offers get buried
- **Over-optimization for short-term revenue**: Hurts long-term user trust
- **Trust & Safety breakdowns**: Lead to moderation challenges, reputational damage
- **Infra unreliability**: Critical issues during checkout, streaming, etc.


